<?php
	include 'includes/session.php';
	$conn = $pdo->open();

	$output = array('list'=>'','count'=>0);

	if(isset($_SESSION['user'])){
		try{
			$stmt = $conn->prepare("SELECT *, cart.id AS cartid, products.name AS prodname, category.name AS catname FROM cart LEFT JOIN products ON products.id=cart.product_id LEFT JOIN category ON category.id=products.category_id WHERE user_id=:user_id");
			$stmt->execute(['user_id'=>$_SESSION['user']]);
			$output['list'] = "<li class='shopping-cart-title clearfix'>
			<label>Your Product</label>
			<label>Price</label>
		</li>
			<li class='product-item' >";
			$price=0;
			foreach($stmt as $row){
				$output['count']++;
				$image = (!empty($row['photo'])) ? FULL_PATH.'ecommerce/images/'.$row['photo'] : FULL_PATH.'ecommerce/images/noimage.jpg';
				$productname = (strlen($row['prodname']) > 30) ? substr_replace($row['prodname'], '...', 27) : $row['prodname'];
				$price=$price + $row['discount_price'];
				$output['list'] .= "
				
					<table class='table cart-table'>
					<tbody>
										   <tr>
											   <td class='product-item-image'>
												   <a href='".FULL_PATH."detail/'".$row['id']." class='' title=''>
													   <img src='".$image."'alt='' class='img-responsive'>
												   </a>
												   <button type='button' data-id='".$row['cartid']."'  class='remove-product-cart smooth cart_delete' >
													   <i class='fa fa-times'></i>
												   </button>
											   </td>
											   <td class='product-item-name'>
												   <h4 class='product-name'>
													   <a href='".FULL_PATH."detail/".$row['id']."' class='smooth' title=''>".$row['prodname']."</a>
												   </h4>
												   <span class='product-item-quantity'>".$row['quantity']."</span>
											   </td>
											   <td class='product-item-price'>
												   <span class='shopping-price'>AED ".$row['discount_price']."</span>
											   </td>
										   </tr>
										
									   </tbody>
									   </table>
									 
						
						
				";
			}
			$output['list'].="  </li>
								
			<li class='total-price clearfix'>
				<label class='total-title'>TOTAL:</label>
				<label class='float-right'>AED ".$price."</label>
			</li>
			<li class='shopping-cart-checkout'>
				<a href='".FULL_PATH."cart' class='smooth' title=''>GO TO CART</a>
			
			</li>";
		}
		catch(PDOException $e){
			$output['message'] = $e->getMessage();
		}
	}
	else{
		if(!isset($_SESSION['cart'])){
			$_SESSION['cart'] = array();
		}

		if(empty($_SESSION['cart'])){
			$output['count'] = 0;
		}
		else{
			$output['list'] = " <li class='shopping-cart-title clearfix'>
			<label>Your Product</label>
			<label>Price</label>
		</li>
			<li class='product-item' >";
			$price=0;
			foreach($_SESSION['cart'] as $row){
				
				$output['count']++;
				$stmt = $conn->prepare("SELECT *, products.name AS prodname, category.name AS catname FROM products LEFT JOIN category ON category.id=products.category_id WHERE products.id=:id");
				$stmt->execute(['id'=>$row['productid']]);
				$product = $stmt->fetch();
				$price=$price + $product['discount_price'];
				$image = (!empty($product['photo'])) ? FULL_PATH.'ecommerce/images/'.$product['photo'] : FULL_PATH.'ecommerce/images/noimage.jpg';
				$output['list'] .= "
				
					<table class='table cart-table'>
					<tbody>
										   <tr>
											   <td class='product-item-image'>
												   <a href='".FULL_PATH."detail/".$row['productid']."' class='' title=''>
													   <img src='".$image."'alt='' class='img-responsive'>
												   </a>
												   <button type='button' data-id='".$row['productid']."'  class='remove-product-cart smooth cart_delete' >
													   <i class='fa fa-times'></i>
												   </button>
											   </td>
											   <td class='product-item-name'>
												   <h4 class='product-name'>
													   <a href='".FULL_PATH."detail/".$row['productid']."' class='smooth' title=''>".$product['prodname']."</a>
												   </h4>
												   <span class='product-item-quantity'>".$row['quantity']."</span>
											   </td>
											   <td class='product-item-price'>
												   <span class='shopping-price'>AED ".$product['discount_price']."</span>
											   </td>
										   </tr>
										
									   </tbody>
									   </table>
									 
						
						
				";
				
			}
			$output['list'].="  </li>
								
			<li class='total-price clearfix'>
				<label class='total-title'>TOTAL:</label>
				<label class='float-right'>AED ".$price."</label>
			</li>
			<li class='shopping-cart-checkout'>
				<a href='".FULL_PATH."cart' class='smooth' title=''>GO TO CART</a>
				
			</li>";
		}
	}

	$pdo->close();
	echo json_encode($output);

?>
			